/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.util;

public class NumericAlphaVersion
implements Comparable {
    private int numeric;
    private String alpha;

    public NumericAlphaVersion(String version) {
        try {
            this.extract(version);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported numeric-alpha version format: " + version + "; " + e);
        }
    }

    public int compareTo(Object obj) {
        NumericAlphaVersion naVer = (NumericAlphaVersion)obj;
        if (this.numeric != naVer.numeric) {
            return this.numeric < naVer.numeric ? -1 : 1;
        }
        return this.alpha.compareTo(naVer.alpha);
    }

    public boolean equals(Object obj) {
        boolean equal;
        try {
            equal = this.compareTo(obj) == 0;
        }
        catch (Exception e) {
            equal = false;
        }
        return equal;
    }

    public int hashCode() {
        return this.numeric + this.alpha.hashCode();
    }

    public String toString() {
        return this.numeric + this.alpha;
    }

    private void extract(String version) {
        this.numeric = 0;
        this.alpha = "";
        if (version.equals("")) {
            return;
        }
        int i = 0;
        while (i < version.length()) {
            if (!Character.isDigit(version.charAt(i))) break;
            ++i;
        }
        this.numeric = Integer.parseInt(version.substring(0, i));
        this.alpha = version.substring(i);
    }
}

